/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.console;

import filenet.sim.apps.console.VWSIMConsoleCore;
import filenet.sim.apps.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;
import javax.swing.ImageIcon;

public class VWSIMConsoleApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWSIMConsoleCore m_consoleCore = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(VWSIMResource.s_poConsoleGroup)) {
                System.exit(1);
            }
            VWSIMConsoleApplication pApp = new VWSIMConsoleApplication();
            pApp.init(sessionInfo);
            VWSIMHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            System.exit(1);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            VWSplashWindow splashWindow = new VWSplashWindow(this);
            this.setTitle(VWIDMBaseFactory.instance().getVWString(14).toString());
            ImageIcon icon = VWSIMImageLoader.createImageIcon("Console_3D_32.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("sim_console_location", "sim_console_size")) {
                Dimension dim = VWStringUtils.stringToDimension("800,600");
                if (dim == null) {
                    dim = new Dimension(1024, 768);
                }
                this.updatePosition(dim.width, dim.height);
            }
            this.show();
            if (splashWindow != null) {
                splashWindow.start(this, 1000);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_consoleCore = new VWSIMConsoleCore();
            this.m_consoleCore.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_consoleCore != null) {
                this.m_consoleCore.destroy();
                this.m_consoleCore = null;
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

